/*
 * Decompiled with CFR 0.152.
 */
package filenet.pe.ceutils;

import java.io.Serializable;

public class ConnectionPoint
implements Serializable {
    private static final long serialVersionUID = 464L;
    public String Name = null;
    public String DNSName = null;
    public int BrokerPort = -1;
    public int IsolatedRegionNumber = -1;
    public String CEURI = null;
    public byte[] IdentityToken = null;
    private String m_desc = null;
    private String m_corbaURI = null;

    public ConnectionPoint() {
    }

    private static String trimSpaces(String s) {
        return s == null ? null : s.trim();
    }

    public ConnectionPoint(String name, String dnsName, int brokerPort, int isolatedRegionNumber, String CEURI) {
        this.Name = ConnectionPoint.trimSpaces(name);
        this.DNSName = ConnectionPoint.trimSpaces(dnsName);
        this.BrokerPort = brokerPort;
        this.IsolatedRegionNumber = isolatedRegionNumber;
        this.CEURI = ConnectionPoint.trimSpaces(CEURI);
    }

    public String getCorbaServerURI() {
        if (this.m_corbaURI == null) {
            StringBuffer buf = new StringBuffer();
            buf.append("corba://").append(this.DNSName).append(":").append(this.BrokerPort).append("/").append(this.IsolatedRegionNumber);
            this.m_corbaURI = buf.toString();
        }
        return this.m_corbaURI;
    }

    public String toString() {
        if (this.m_desc == null) {
            StringBuffer buf = new StringBuffer();
            if (this.CEURI != null) {
                buf.append("[").append(this.CEURI).append("]");
            }
            buf.append(this.Name).append(", ").append(this.DNSName).append(":").append(this.BrokerPort).append("(").append(this.IsolatedRegionNumber).append(")");
            this.m_desc = buf.toString();
        }
        return this.m_desc;
    }

    public boolean equals(ConnectionPoint obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return this.Name.equalsIgnoreCase(obj.Name) && this.IsolatedRegionNumber == obj.IsolatedRegionNumber && this.DNSName.equals(obj.DNSName);
    }

    public static String _get_FILE_DATE() {
        return "$Date:   21 Mar 2008 15:44:36  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.3  $";
    }
}

